<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

require_once __DIR__ .  DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'Core' . DIRECTORY_SEPARATOR . 'Bootstrap.php';

use Symfony\Component\HttpFoundation\Request;
use PhoxTemplates\Includes\App\Database\Databases;
use WHMCS\View\Menu\Item as MenuItem;

add_hook('ClientAreaPage', 1, function($vars) {
    $request = new Request(
        $_GET
    );
    $installed_template = Databases::instance()->getInstalledTemplateName();

    $vars['phoxTemplateName'] = $installed_template;

    $db = Databases::instance();

    $allOptions = [];

    foreach (json_decode($db->getAllOptions(), true) as $item){
        $allOptions [$item['option']] = $item['value'];
    }

    $vars['phoxRegistrationDisabled'] = !WHMCS\Config\Setting::getValue("AllowClientRegister");

    $vars['phoxTemplateOptions'] = $allOptions;

    return $vars;
});


// Change Main Menu Home Text To Icon
add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar)
{

    if ( ! is_null($primaryNavbar->getChild('Home') ) ) {
        $primaryNavbar->removeChild('Home');
    }

    if ( ! is_null($primaryNavbar->getChild('Network Status' ) ) ) {
        $primaryNavbar->removeChild('Network Status');
    }

});
