<?php

namespace PhoxTemplates\Includes\App\Database;

use Exception;
use \WHMCS\Database\Capsule;

/**
 * Databases
 */
class Databases
{

	private $schemaBuilder;

	private static $instance = null;

    private const settingsTable = 'phoxtemplatesettings';

	private const addonTable = 'tbladdonmodules';

	public static function instance()
	{
		if (empty(self::$instance))
		{
			self::$instance = new self;
		}

		return self::$instance;
	}

	final private function __construct()
	{

		$this->schemaBuilder = Capsule::schema();


	}

    /**
     * Create table phoxtemplatesettings and add some default settings
     */
    public function up_db(){

        //build table
        if (!$this->schemaBuilder->hasTable(self::settingsTable)) {
            $this->schemaBuilder->create(self::settingsTable, function ($table){
                $table->bigIncrements('id');
                $table->text('option');
                $table->text('value');
            });
        }

        //set default value
        try{
            Capsule::table(self::settingsTable)->insert([
                ['option' =>'lightlogo', 'value' => ''],
                ['option' =>'darklogo', 'value' => ''],
            ]);

        }catch (Exception $e){

            echo "Unable to insert default data : {$e->getMessage()}";

        }

    }

    /**
     * Delete records `template_name` from table `tbladdonmodules` & remove table `phoxtemplatesettings`
     */
	public function down_db()
	{
        try {
            $this->schemaBuilder->dropIfExists('phoxtemplatesettings');
        }catch (Exception $e){

            echo "Unable to delete record template_name from table phoxtemplatesettings : {$e->getMessage()}";

        }

        try {

        Capsule::table('tbladdonmodules')->where([
		    ['module', 'phox_templates'],
            ['setting', 'template_name']
        ])->delete();

        }catch (Exception $e){

            echo "Unable to delete record template_name from table tbladdonmodules : {$e->getMessage()}";

        }

    }


    /**
     * Check if `template_name` setting on table `tbladdonmodules` has been change need to change
     * or that have the same value
     *
     * @param string $templa_name
     * @return bool
     */
    public function isteplateset( string $templa_name){

        $result = false;

        $adddonTable =  Capsule::table(self::addonTable)->where([['module', '=', 'phox_templates'], ['setting', '=', 'template_name']])->first();

        if(empty( $adddonTable ) ){
            $result = true;
        }else{
            $result = ($adddonTable->value === $templa_name) ? false : true ;
        }

        return $result;
    }

    /**
     * Insert new record to table tbladdonmodules
     * or Update the record by add selected template name in table
     *
     * @param string $template_name
     * @return mixed
     * @throws Exception
     *
     */
    public function insertOrUpdateSelectedTemplate( string $template_name){

        if( empty( $template_name ) OR ! $this->isteplateset($template_name) )  return false;

        try {

            Capsule::table(self::addonTable)->updateOrInsert(
                [
                    'module' => 'phox_templates',
                    'setting' => 'template_name'
                ],
                [
                    'module'  => 'phox_templates',
                    'setting' => 'template_name',
                    'value'   => $template_name
                ]
            );

            return true ;

        }catch (Exception $e){

            echo "Unable to insert Or Update tbladdonmodules: {$e->getMessage()}";

        }

    }

    /**
     * get from record template_name get the template name from table tbladdonmodules
     *
     * @return mixed
     */
    public function getInstalledTemplateName(){
        try {

            $data = Capsule::table(self::addonTable)->where([['module', '=', 'phox_templates'], ['setting', '=', 'template_name']])->first();

            if(is_object($data)){
                return $data->value;
            }else{
                return 'classy';
            }

        }catch (Exception $e){

            echo "Unable to insert Or Update tbladdonmodules: {$e->getMessage()}";

        }
    }

    /**
     * Update option on table `phoxtemplatesettings`
     *
     * @return mixed
     */
    public function updateOption($option, $value){

        try{
            Capsule::table('phoxtemplatesettings')->where('option', $option)->update(['value' => $value]);
        }catch (Exception $e){

            echo "Unable to update {$option} on table phoxtemplatesettings : {$e->getMessage()}";

        }


    }

    public function getAllOptions(){
        try{
            return Capsule::table('phoxtemplatesettings')->select('option', 'value')->get();
        }catch (Exception $e){

            echo "Unable to get all options on table phoxtemplatesettings : {$e->getMessage()}";

        }
    }


}