<?php
namespace PhoxTemplates\Includes\App\Demos;

use PhoxTemplates\Includes\App\Demos\TemplateBase;

class Loader{

    /**
     * @var \PhoxTemplates\Includes\App\Demos\TemplateBase|null
     */
    private $demo_init ;

    /**
     * instance
     *
     * @var null
     */
    private static $instance = null;

    /**
     * instance
     *
     * @return Loader|null
     */
    public static function instance()
    {
        if (empty(self::$instance))
        {
            self::$instance = new self;
        }

        return self::$instance;
    }

    final public function __construct()
    {

        $this->demo_init = TemplateBase::instance() ;

    }

    /**
     * Load Templates
     *
     * run all demos function and collect data from array and return with it on array
     *
     * @return array
     */
    public function load_templates(){

       $templates_collector = [];

        //Go
        $templates_collector [] = $this->go();

        //Shiny
        $templates_collector [] = $this->shiny();

        //classy
        $templates_collector [] = $this->classy();

        //wohost
        $templates_collector [] = $this->wohost();

        //super
        $templates_collector [] = $this->super();

        //modern
        $templates_collector [] = $this->modern();

        //primary
        $templates_collector [] = $this->primary();

       return $templates_collector;

   }

    /**
     * Go Demo
     *
     * @return array
     */
    private function go(){

        $this->demo_init->sit_name('go');
        $this->demo_init->sit_title('Go');
        $this->demo_init->sit_img('go.jpg', false);
        $this->demo_init->sit_style('go.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=go');

        return $this->demo_init->get_demo();

   }

    /**
     * Shiny Demo
     *
     * @return array
     */
    private function shiny(){

        $this->demo_init->sit_name('shiny');
        $this->demo_init->sit_title('Shiny');
        $this->demo_init->sit_img('shiny.jpg', false);
        $this->demo_init->sit_style('shiny.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=shiny');

        return $this->demo_init->get_demo();

   }

    /**
     * classy Demo
     *
     * @return array
     */
    private function classy(){

        $this->demo_init->sit_name('classy');
        $this->demo_init->sit_title('Classy');
        $this->demo_init->sit_img('classy.jpg', false);
        $this->demo_init->sit_style('classy.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=classy');

        return $this->demo_init->get_demo();

   }

    /**
     * wohost Demo
     *
     * @return array
     */
    private function wohost(){

        $this->demo_init->sit_name('wohost');
        $this->demo_init->sit_title('WoHost');
        $this->demo_init->sit_img('wohost.jpg', false);
        $this->demo_init->sit_style('wohost.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=wohost');

        return $this->demo_init->get_demo();

    }

    /**
     * Super Demo
     *
     * @return array
     */
    private function super(){

        $this->demo_init->sit_name('super');
        $this->demo_init->sit_title('Super');
        $this->demo_init->sit_img('super.jpg', false);
        $this->demo_init->sit_style('super.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=super');

        return $this->demo_init->get_demo();

    }

    /**
     * Modern Demo
     *
     * @return array
     */
    private function modern(){

        $this->demo_init->sit_name('modern');
        $this->demo_init->sit_title('Modern');
        $this->demo_init->sit_img('modern.jpg', false);
        $this->demo_init->sit_style('modern.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=modern');

        return $this->demo_init->get_demo();

   }

    /**
     * primary Demo
     *
     * @return array
     */
   private function primary(){

        $this->demo_init->sit_name('primary');
        $this->demo_init->sit_title('Primary');
        $this->demo_init->sit_img('primary.jpg', false);
        $this->demo_init->sit_style('primary.css', false);
        $this->demo_init->sit_preview('https://preview.whmcsdes.com/index.php?systpl=phox&carttpl=phox&wdesstyle=primary');

        return $this->demo_init->get_demo();

   }

}
