<?php

namespace PhoxTemplates\Includes\Core\Render;

/**
 * Smarty
 */
class Smarty{

	private static $instance = null;
	private $smarty;

	/**
	 * Instance Smarty
	 *
	 * @return null|Smarty
	 */
	public static function instance()
	{
		if (empty(self::$instance))
		{
			self::$instance = new self;
		}

		return self::$instance;
	}

	final private function __construct()
	{
		$this->smarty = new \Smarty();
	}


	public function view( $template, $vars = [] ){

		if( empty( $template ) ){

			throw new \Exception( sprintf( ' The $template is empty ' ) );
		}

		$this->smarty->caching  = 0;

		$this->clear();

		if (is_array($vars))
		{
			foreach ($vars as $key => $val)
			{
				$this->smarty->assign($key, $val);
			}
		}

		$file = PHOXDIR . DS .'templates' . DS . $template . '.tpl';


		if (!file_exists($file)){

			throw new \Exception( sprintf( ' Unable to find Template: %s', $file ) );

		}

		return $this->smarty->display($file , uniqid());


	}


	protected function clear()
	{
		if (method_exists($this->smarty, 'clearAllAssign'))
		{
			$this->smarty->clearAllAssign();
		}
		elseif (method_exists($this->smarty, 'clear_all_assign'))
		{
			$this->smarty->clear_all_assign();
		}
	}

}