<div class="phox-module">
  <div class="head">
    <div class="info">
      <div class="title">
        <h2>Phox Options</h2>
        <span>{$version}</span>
      </div>
      <p>
        Developed by
        <a target="_blank" href="https://whmcsdes.com">WHMCSdes</a>
      </p>
    </div>
    <a target="_blank" href="https://whmcsdes.com/ca/submitticket.php">Submit a Ticket</a>
  </div>
  <div class="content">
    <!-- Tabs -->
    <div id="tabs-phox">
      <ul>
        <li><a href="#demos"><i class="fad fa-paint-brush"></i> Demos</a></li>
        <li><a href="#branding"><i class="fad fa-adjust"></i> Branding</a></li>
      </ul>
      <!-- Demos -->
      <div id="demos">
        <div class="block">
          <h2>Choose a Demo</h2>
          <!-- Feed Back -->
          <div id="result-area"></div>
          <!-- End Feed Back-->
          <div class="list">
            {foreach from=$templates item=template}
              <!-- item -->
              <div class="item">
                <a target="_blank" href="{$template.preview}">
                  {if $template.img.external eq true }
                    <img src="{$template.img.link}" alt="{$template.name}" />
                  {else}
                    <img src="../modules/addons/phox_templates/templates/img/demos/{$template.img.link}"
                      alt="{$template.name}" />
                  {/if}
                </a>
                <div class="info">
                  <h2>{$template.name}</h2>
                  <div class="actions">
                    <a target="_blank" href="{$template.preview}">Preview</a>
                    {if $installed eq $template.id }
                      <p id="installed" data-installed="{$template.id}">Installed</p>
                    {else}
                      <a href="#" class="install-template" data-name="{$template.id}">+ Install</a>
                    {/if}
                  </div>
                </div>
              </div>
            {/foreach}
          </div>
        </div>
      </div>
      <!-- Branding -->
      <div id="branding">
        <div class="row">
          <div class="col-md-6">
            <div class="block">
              <h2>Logo (Dark Mode)</h2>
              <form action="/file-upload" id="darkLogo" class="dropzone">
              </form>
            </div>
          </div>
          <div class="col-md-6">
            <div class="block">
              <h2>Logo (Light Mode)</h2>
              <form action="/file-upload" id="lightLogo" class="dropzone">
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  window.whmcssystemurl = '{$web_root}';
  window.DarkLogoImagesize = { size: '{$logo_images["dark-logo"]["size"]}', status: '{$logo_images["dark-logo"]["status"]}' }
  window.LightLogoImagesize = { size: '{$logo_images["light-logo"]["size"]}', status: '{$logo_images["light-logo"]["status"]}' }
</script>
