$(document).ready(function () {
  var installTemplate = function (templateName, clickTarget) {
    if (templateName.length > 0) {
      $.ajax({
        method: "POST",
        url: "addonmodules.php?module=phox_templates&action=save",
        data: { templateName: templateName },
      }).success(function (result) {
        $(".loader--style1").remove();
        if (result.state) {
          if (jQuery("#installed").length === 1) {
            var installed = jQuery("#installed"),
              installedTemplateName = installed.data("installed");
            installed.after(
              '<a href="#" class="install-template" data-name="' +
                installedTemplateName +
                '">+ Install</a>'
            );
            installed.remove();
          }
          jQuery(clickTarget).after(
            '<p id="installed" data-installed = "' +
              templateName +
              '">Installed</p>'
          );
          jQuery(clickTarget).remove();
        } else {
          jQuery("#result-area").append(
            '<div class="alert alert-failed"><h2>' +
              result.message +
              "</h2></div>"
          );
          jQuery(".alert-failed")
            .first()
            .fadeOut(1300, function () {
              $(this).remove();
            });
        }
      });
    }
  };
  jQuery(".item").on("click", ".install-template", function (e) {
    var templName = jQuery(this).data("name");
    $(this).hide();
    jQuery(this).after(
      '<div class="loader loader--style1" title="0"><i class="fad fa-circle-notch fa-spin"></i></div>'
    );
    installTemplate(templName, this);
  });
  Dropzone.autoDiscover = false;

  var darkLogo = new Dropzone("#darkLogo", {
    url: "addonmodules.php?module=phox_templates&action=savebrand",
    paramName:'dark-logo',
    maxFilesize: 6,
    thumbnailWidth: null,
    init: function() {
      var thisDropzone = this;
      this.on('addedfile', function(file) {

        if (this.files.length > 1) {
          this.removeFile(this.files[0]);
        }
      });

      if(DarkLogoImagesize.status){
        var mockFile = { name: 'dark-logo', size: DarkLogoImagesize.size, type: 'image/png' };
          this.emit("addedfile", mockFile);
          this.emit("thumbnail", mockFile, whmcssystemurl+"templates/phox/img/dark-logo.png")
          this.emit("complete", mockFile);
          this.files = [mockFile];
      }

    }
  });

  var lightLogo = new Dropzone("#lightLogo", {
    url: "addonmodules.php?module=phox_templates&action=savebrand",
    paramName:'light-logo',
    maxFilesize: 6,
    thumbnailWidth: null,
    init: function() {

      this.on('addedfile', function(file) {
        if (this.files.length > 1) {
          this.removeFile(this.files[0]);
        }
      });
      if(LightLogoImagesize.status){
        var mockFile = { name: 'light-logo', size: LightLogoImagesize.size, type: 'image/png' };
        this.emit("addedfile", mockFile);
        this.emit("thumbnail", mockFile, whmcssystemurl+"templates/phox/img/light-logo.png")
        this.emit("complete", mockFile);
        this.files = [mockFile];
      }
    }
  });

});
