<?php
namespace PhoxTemplates\Includes\App\Demos;

use PhoxTemplates\Includes\Core\Demos\DemoAbstract;

class TemplateBase extends DemoAbstract{

    /**
     * instance
     *
     * @var null
     */
    private static $instance = null;

    /**
     * instance
     *
     * @return TemplateBase|null
     */
    public static function instance()
    {
        if (empty(self::$instance))
        {
            self::$instance = new self;
        }

        return self::$instance;
    }



    /**
     * Sit Name
     *
     * @param string $name
     * @return string
     */
    public function sit_name(string $name)
    {
        $this->name = $name;

    }

    /**
     * sit title
     *
     * @param string $title
     * @return string
     */
    public function sit_title(string $title)
    {
        return $this->title = $title;
    }

    /**
     * Sit Image
     *
     * @param string $link
     * @param bool $external
     * @return array
     */
    public function sit_img(string $link, bool $external)
    {
        return $this->image =  [
            'link' => $link,
            'external' => $external
        ];
    }

    /**
     * Sit Style
     *
     * @param string $link
     * @param bool $external
     * @return array
     */
    public function sit_style(string $link, bool $external)
    {
        return $this->style = [
            'link' => $link,
            'external' => $external
        ];
    }

    /**
     * Sit Preview
     *
     * @param string $link
     * @return string
     */
    public function sit_preview(string $link)
    {
        return $this->preview_link = $link;
    }

    /**
     * Get Demo
     *
     * @return array
     */
    public function get_demo(){

        return [
            'id'      => $this->name,
            'name'    => $this->title,
            'img'     => $this->image,
            'style'   => $this->style,
            'preview' => $this->preview_link
        ];

    }

}


