<?php
namespace PhoxTemplates\Includes\Core\Http;


use Symfony\Component\Yaml\Yaml;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class RoutingProvider use to route the links and fire the controller
 *
 * @since 1.0.0
 *
 */
class RoutingProvider {


	function __construct()
	{

		$route_collection = $this->yaml_data(dirname(__DIR__, 1) . '/Config/routes.yaml');

		$controller = $this->matcher($route_collection);

		$this->run_controller($controller);


	}

	/**
	 * Parses a YAML file into a array value.
	 *
	 * @param $file string The file name
	 * @return array
	 * @throws \Exception if the file could not be read or the YAML is not valid
	 */
	public function yaml_data( $file ){

		if( ! is_file($file) ){
			throw new \Exception(sprintf('File "%s" does not exist.', $file));
		}

		if ( ! is_readable($file) ) {
			throw new \Exception(sprintf('File "%s" cannot be read.', $file));
		}

		return Yaml::parse( file_get_contents( $file ) );

	}

	public function check_yaml_structure($routes_yaml){

		if( ! is_array($routes_yaml) ){
			throw new \Exception(printf( '$routes is not array' ));
		}

		array_map( function ($key , $value){
			if( ! is_string($key) ){
				throw new \Exception(sprintf( 'the key in yaml file must be string not %s', gettype($key) ));
			}

			if(  is_null( $value['value'] ) ||  is_null( $value['controller'] ) ){
				foreach ( $value as $k => $v ){
					if(  is_null( $v['value'] ) ||  is_null( $v['controller'] ) ){
						throw new \Exception(sprintf( 'There are found a problem in yaml structure' ));
					}
				}

			}

		}, array_keys($routes_yaml), $routes_yaml );

		return true;

	}


	/**
	 * Get the query value
	 *
	 * @param $query string
	 * @return string|bool $q_value
	 * @throws \Exception if the $query is empty
	 */
	public function request_query($query){

		if( empty( $query ) ){
			throw new \Exception(sprintf('Query "%s" is empty.', $query));
		}

		$request = new Request(
			$_GET,
			$_POST,
			[],
			$_COOKIE,
			$_FILES,
			$_SERVER
		);

		//Check the url location in the addons
		$module_url  = $request->server->get("REQUEST_URI");

		if( ! strpos($module_url, 'addonmodules') ){

			return $q_value = false;

		}

		$q_value = $request->get($query);


		if(  is_null( $q_value )  ){

			$q_value =  false;
		}

		return $q_value;

	}

	/**
	 * Match the routes with query
	 *
	 * @param $routes array all routes from yamll file
	 * @return string
	 * @throws \Exception $routes is not have any problem
	 */
	public function matcher($routes){

		if( ! $this->check_yaml_structure( $routes  ) ){

			throw new \Exception(sprintf( 'Problem in $routes ' ));

		}

		$controller = false;

		foreach ($routes as $query => $date){

			if( $this->request_query($query) != false  ){

				if( ! is_null( $date['value'] ) ){
					if( $this->request_query($query) === $date['value'] ){

						$controller = 	$date['controller'];

						break;

					}else{

						$controller = 'PhoxTemplates\Includes\App\Http\Controllers\Dashboard::homepage';

					}

				}else{

					foreach ( $date as $kquery => $vquery ){

						if( $this->request_query($query) === $vquery['value'] ){

							$controller = 	$vquery['controller'];

							break;

						}else{

							$controller = 'PhoxTemplates\Includes\App\Http\Controllers\Dashboard::homepage';

						}

					}
					break;
				}


			}

		}

		return $controller;

	}

	/**
	 * Fire the controller
	 *
	 * @param $controller string
	 * @return mixed
	 * @throws \Exception exists class & method  and method is set in right way in yaml file
	 */
	public function run_controller($controller){

		if ( $controller == false ){
			return false ;
		}

		if( ! strpos($controller, '::') ){
			throw new \Exception( sprintf( ' you did not select method in the class ' ) );
		}

		$splite_controller = explode( '::' ,$controller);

		if( isset( $splite_controller[0] ) && isset($splite_controller[1]) ){
			if ( ! class_exists($splite_controller[0]) ){
				throw new \Exception( sprintf( ' The Class %s is not exists ', $splite_controller[0] ) );
			}

			$calss = new $splite_controller[0];

			$method = $splite_controller[1];

			if( ! method_exists( $calss, $method  ) ){
				throw new \Exception( sprintf( ' The method %s is not exists ', $splite_controller[1] ) );
			}

			return $calss->$method();
		}

		return false;

	}








}