<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Require Files and initialization libraries
 * 1- require Bootstrap file
 */
require_once __DIR__ .  DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'Core' . DIRECTORY_SEPARATOR . 'Bootstrap.php';

/**
 * Run The Route
 */
new PhoxTemplates\Includes\Core\Http\RoutingProvider();

/**
 * Define addon module configuration parameters.
 * @return array
 */
function phox_templates_config()
{
    return [
        // Display name for your module
        'name' => 'Phox WHMCS Templates',
        // Description displayed within the admin interface
        'description' => 'This module helps you to install Phox WHMCS templates. '
            . '<br/> <strong>Note:</strong> This templates use exclusive with <a href="https://1.envato.market/RDGA9">Phox Theme</a> ',
        // Module author name
        'author' => '<a href="https://whmcsdes.com">WHMCSDES</a>',
        // Default language
        'language' => 'english',
        // Version number
        'version' => '1.0.2',
    ];
}

/**
 * Activate.
 */
function phox_templates_activate()
{
    //Build new table
    $databases_migrations = \PhoxTemplates\Includes\App\Database\Databases::instance();
    $databases_migrations->up_db();
}

/**
 * Deactivate.
 *
 * @see https://developers.whmcs.com/advanced/db-interaction/
 *
 * @return array Optional success/failure message
 */
function phox_templates_deactivate()
{
    //Drop Database
    $databases_migrations = \PhoxTemplates\Includes\App\Database\Databases::instance();
    $databases_migrations->down_db();
}

/**
 * Admin Output
 *
 * @param $vars
 */
function phox_templates_output($vars) {
    //Template Load By Routing
    //print ('<link href="../modules/addons/phox_templates/templates/css/reset.css" rel="stylesheet">');
    print ('<link href="../modules/addons/phox_templates/templates/css/custom.css" rel="stylesheet">');
    // Tabs
    print ('<script src="../modules/addons/phox_templates/templates/js/jquery-ui.js" crossorigin="anonymous"></script>');
    print ('<script>$(function() { $("#tabs-phox").tabs({ active: 0 }); });</script>');
    // Dropzone Upload Files
    print ('<link href="../modules/addons/phox_templates/templates/css/dropzone.min.css" rel="stylesheet">');
    print ('<script src="../modules/addons/phox_templates/templates/js/dropzone.min.js" crossorigin="anonymous"></script>');
    // Custom
    print ('<script src="../modules/addons/phox_templates/templates/js/script.js" crossorigin="anonymous"></script>');
    print('<link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Karla:wght@400;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">');


}

/**
 * Upgrade version
 *
 * @param $vars
 */
function  phox_templates_upgrade($vars){

    $currentlyInstalledVersion = $vars['version'];

    if ($currentlyInstalledVersion < '1.0.2') {
        //Build new table
        $databases_migrations = \PhoxTemplates\Includes\App\Database\Databases::instance();
        $databases_migrations->up_db();
    }

}



